/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroformat;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Ecliptic;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Parsing;
import cds.astro.Supergal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class Astroframe
implements Serializable {
    protected static boolean DEBUG = false;
    protected static double eps = AstroMath.eps;
    public static final double Jsec = 3.168808781402895E-8;
    public static final double[] Udot = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    protected static ArrayList fixedFrames = null;
    protected static HashMap fixedNames = null;
    public static final char[] IAUframes = new char[]{'\u001b', 'I', 'G', 'S', 'B', 'J', 'E'};
    public String name;
    public String full_name;
    public double epoch = Double.NaN;
    public boolean hms = false;
    public double[] fromICRSmatrix = null;
    public double[] toICRSmatrix = null;
    protected double max_spin = 0.0;
    public double[] dotMatrix = Udot;
    public byte fixed = 0;
    static final byte HIPdef = 1;
    public byte precision = (byte)8;
    public byte ed_lon = (byte)32;
    public byte ed_lat = (byte)48;
    protected int usage = 0;
    public HashMap savedConversions = null;

    public void dump(String string) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = string.indexOf("(R)") >= 0;
        String string2 = string.charAt(0) == '#' ? "#   " : "    ";
        System.out.print(string);
        if (string.endsWith("\n")) {
            System.out.print(string2);
        }
        System.out.println("[" + this.getClass() + "] name=(" + this.name + ") full_name=(" + this.full_name + ") epoch=J" + this.epoch + " fixed=0x" + Integer.toHexString(this.fixed & 0xFF) + " usage=" + this.usage);
        System.out.print(string2 + " precision=" + this.precision + ", ed_lon=0x" + Integer.toHexString(this.ed_lon) + '(' + Astroformat.explain(this.ed_lon) + ')');
        System.out.print(" ed_lat=0x" + Integer.toHexString(this.ed_lat) + '(' + Astroformat.explain(this.ed_lat) + ')');
        if ((this.fixed & 0x80) != 0) {
            int n = fixedFrames.indexOf(this);
            System.out.print("\n" + string2 + "#" + n + ";\tNames:");
            object3 = fixedNames.keySet();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (Integer)fixedNames.get(object2);
                if ((Integer)object != n) continue;
                System.out.print(" \"" + (String)object2 + "\"");
            }
        }
        if (this.savedConversions != null) {
            System.out.print("; savedConversions=" + this.savedConversions.size());
            if (bl) {
                System.out.print(":");
                Set set = this.savedConversions.keySet();
                object3 = set.iterator();
                int n = 0;
                while (object3.hasNext()) {
                    object2 = (Astroframe)object3.next();
                    object = (double[])this.savedConversions.get(object2);
                    System.out.print("\n" + string2 + " * [" + ((Object)object).length + "]=>" + ((Astroframe)object2).full_name);
                    ++n;
                }
            }
        }
        System.out.print("\n");
        AstroMath.printMatrix(string2 + "toICRSmatrix:\n", this.toICRSmatrix);
        AstroMath.printMatrix(string2 + "fromICRSmatrix:\n", this.fromICRSmatrix);
        AstroMath.printMatrix(string2 + "dotMatrix(max_spin=" + this.max_spin + "):\n", this.dotMatrix);
    }

    public static void dumpAll(String string) {
        System.out.print(string);
        if (fixedFrames == null) {
            System.out.println(" (empty)");
            return;
        }
        System.out.println(" (" + fixedFrames.size() + " recorded)");
        boolean bl = string.indexOf("(R)") >= 0;
        Iterator iterator = fixedFrames.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Astroframe astroframe = (Astroframe)iterator.next();
            String string2 = "[" + n + "]";
            if (n < 10) {
                string2 = string2 + " ";
            }
            if (bl) {
                string2 = string2 + " (R)";
            }
            astroframe.dump(string2);
            ++n;
        }
        System.out.println(string + " (End)");
    }

    public static Astroframe Gaia2() {
        String string = "Gaia2";
        Astroframe astroframe = Astroframe.getFrame(string);
        if (astroframe == null) {
            astroframe = ICRS.create(2015.5);
            astroframe.fixFrame(string);
        }
        ++astroframe.usage;
        return astroframe;
    }

    public static Astroframe Hipparcos() {
        String string = "Hipparcos";
        Astroframe astroframe = Astroframe.getFrame(string);
        if (astroframe == null) {
            astroframe = ICRS.create(1991.25);
            astroframe.fixFrame(string);
        }
        ++astroframe.usage;
        return astroframe;
    }

    public static Astroframe create(char c) {
        if (fixedFrames == null) {
            ICRS.create();
        }
        for (int i = 1; i < IAUframes.length; ++i) {
            if (c != IAUframes[i]) continue;
            Astroframe astroframe = (Astroframe)fixedFrames.get(i);
            ++astroframe.usage;
            return astroframe;
        }
        return null;
    }

    public static Astroframe create() {
        return ICRS.create();
    }

    public static final Astroframe getFrame(String string) {
        Integer n;
        if (string.length() < 1) {
            return null;
        }
        if (fixedNames == null) {
            ICRS.create();
        }
        if ((n = (Integer)fixedNames.get(string)) == null) {
            int n2 = 0;
            int n3 = string.length() - 1;
            boolean bl = false;
            if (string.charAt(n3) == ':') {
                bl = true;
                --n3;
            }
            if (string.charAt(0) == '\"' && string.charAt(n3) == '\"') {
                bl = true;
                ++n2;
                --n3;
            }
            if (bl) {
                n = (Integer)fixedNames.get(string.substring(n2, n3 + 1));
            }
        }
        return n == null ? null : (Astroframe)fixedFrames.get(n);
    }

    private static final String updateEpoch(String string, double d, boolean bl) {
        String string2 = string;
        int n = string.indexOf("Ep=");
        if (n >= 0) {
            char c = string2.charAt(n + 3);
            string2 = c == 'B' ? string2.substring(0, n + 4) + Astrotime.J2B(d) : string2.substring(0, n + 3) + "J" + d;
        } else {
            if (!bl) {
                return string;
            }
            string2 = string2 + ",Ep=J" + d;
        }
        if (string2.indexOf(40) >= 0 && string2.indexOf(41) < 0) {
            string2 = string2 + ')';
        }
        return string2;
    }

    public static Astroframe parse(Parsing parsing) {
        return Astroframe.parse2(parsing, true);
    }

    public static Astroframe parse2(Parsing parsing, boolean bl) {
        int n;
        int n2;
        int n3;
        if (fixedNames == null) {
            ICRS.create();
        }
        boolean bl2 = false;
        double d = Double.NaN;
        double d2 = Double.NaN;
        boolean bl3 = true;
        Astrotime astrotime = new Astrotime();
        boolean bl4 = false;
        Astroframe astroframe = null;
        parsing.gobbleSpaces();
        int n4 = parsing.pos;
        boolean bl5 = parsing.currentChar() == '(';
        int n5 = n3 = parsing.length;
        if (bl5) {
            n3 = parsing.matchingBracket();
            if (n3 < 0) {
                return null;
            }
            n5 = n3 + 1;
            parsing.advance(1);
            parsing.gobbleSpaces();
        } else {
            n2 = parsing.pos;
            while (parsing.pos < n3 && parsing.currentChar() != ' ') {
                parsing.advance(1);
            }
            n5 = n3 = parsing.pos;
            parsing.advance(-1);
            n = parsing.currentChar();
            if (n == 58 || n == 61) {
                --n3;
            }
            parsing.set(n2);
        }
        astroframe = Astroframe.getFrame(parsing.toString(n3 - parsing.pos));
        if (astroframe != null) {
            parsing.set(n5);
            ++astroframe.usage;
            return astroframe;
        }
        n2 = parsing.lookup(IAUframes);
        if (DEBUG) {
            System.out.println("#...Astroframe.parse: id=" + n2 + " <" + parsing + ">");
        }
        if (n2 >= 0) {
            if (n2 == 2 && parsing.matchIgnoreCase("aia")) {
                n2 = 1;
            }
            if (n2 != 4 && n2 != 5) {
                while (Character.isLetter(parsing.currentChar())) {
                    parsing.advance(1);
                }
                parsing.match('.');
            }
        } else if (parsing.matchIgnoreCase("FK")) {
            n2 = Character.getNumericValue(parsing.currentChar());
            if (n2 == 4 || n2 == 5) {
                parsing.advance(1);
            } else {
                n2 = -1;
            }
        } else if (parsing.matchIgnoreCase("Hip")) {
            d2 = 1991.25;
            n2 = 1;
            while (Character.isLetter(parsing.currentChar())) {
                parsing.advance(1);
            }
            parsing.match('.');
        }
        if (n2 < 0) {
            parsing.set(n4);
            return null;
        }
        bl2 = parsing.match('(');
        if (n2 >= 4 && n2 <= 6) {
            double d3;
            parsing.matchIgnoreCase("Eq=");
            double d4 = d3 = n2 == 4 ? 1950.0 : 2000.0;
            d = Character.isDigit(parsing.currentChar()) ? parsing.parseDecimal() : ((bl4 = astrotime.parse(parsing)) ? (n2 == 4 ? astrotime.getByr() : astrotime.getJyr()) : d3);
            boolean bl6 = bl3 = d == d3;
            if (DEBUG) {
                System.out.println("#...Astroframe.parse: recognized Eq=" + d);
            }
        }
        if (bl2 && parsing.match(')')) {
            bl2 = false;
        }
        if (bl2 || bl5) {
            parsing.gobbleSpaces();
        }
        if (!bl2) {
            bl2 = parsing.match('(');
        }
        if (!parsing.match(',')) {
            parsing.match('/');
        }
        if (Character.toUpperCase(parsing.currentChar()) == 'E') {
            parsing.advance(1);
            if (Character.toLowerCase(parsing.currentChar()) == 'p') {
                while (Character.isLetter(parsing.currentChar())) {
                    parsing.advance(1);
                }
            }
            if (!parsing.match('=')) {
                parsing.match(':');
            }
        }
        if (bl2 || bl5) {
            parsing.gobbleSpaces();
        }
        if (DEBUG) {
            System.out.println("#...Astroframe.parse: examine <" + parsing + ">; equinox=" + d + ", has_par=" + bl2);
        }
        if (parsing.pos >= n5) {
            parsing.set(n5);
        } else if (Character.isDigit(parsing.currentChar())) {
            d2 = parsing.parseDecimal();
        } else {
            bl4 = astrotime.parse(parsing);
            if (bl4) {
                double d5 = d2 = n2 == 4 ? astrotime.getByr() : astrotime.getJyr();
            }
        }
        if (bl2 || bl5) {
            parsing.gobbleSpaces();
        }
        if (bl2) {
            parsing.match(')');
        }
        if (bl5) {
            parsing.gobbleSpaces();
            parsing.match(')');
        }
        if (!parsing.match(':')) {
            parsing.match('=');
        }
        if (Double.isNaN(d2) && parsing.length - parsing.pos > 5) {
            n = parsing.indexOf('J');
            if (n < 0) {
                n = parsing.indexOf('B');
            }
            if (bl4 = n > 0) {
                int n6 = parsing.pos;
                parsing.set(n);
                if (DEBUG) {
                    System.out.println("#...Astroframe.parse: possible epoch as <" + parsing.toString() + ">");
                }
                bl4 = astrotime.parse(parsing);
                parsing.set(n6);
            }
            if (bl4) {
                d2 = n2 == 4 ? astrotime.getByr() : astrotime.getJyr();
                double d6 = 4.0 * d2;
                if (DEBUG) {
                    System.out.println("#...Astroframe.parse: possible epoch: " + d2 + "; frac=" + Math.abs(d6 - Math.rint(d6)));
                }
                boolean bl7 = bl4 = d2 >= 1800.0 && d2 <= 2100.0 && Math.abs(d6 - Math.rint(d6)) <= 3.168808781402895E-8;
            }
            if (!bl4) {
                d2 = Double.NaN;
            }
        }
        if (bl3 && Double.isNaN(d2)) {
            astroframe = (Astroframe)fixedFrames.get(n2);
        } else {
            switch (IAUframes[n2]) {
                case 'I': {
                    astroframe = ICRS.scan(d2);
                    if (astroframe != null || !bl) break;
                    astroframe = new ICRS(d2);
                    break;
                }
                case 'G': {
                    astroframe = Galactic.scan(d2);
                    if (astroframe != null || !bl) break;
                    astroframe = new Galactic(d2);
                    break;
                }
                case 'B': {
                    astroframe = FK4.scan(d, d2);
                    if (astroframe != null || !bl) break;
                    astroframe = new FK4(d, d2);
                    break;
                }
                case 'J': {
                    astroframe = FK5.scan(d, d2);
                    if (astroframe != null || !bl) break;
                    astroframe = new FK5(d, d2);
                    break;
                }
                case 'S': {
                    astroframe = Supergal.scan(d2);
                    if (astroframe != null || !bl) break;
                    astroframe = new Supergal(d2);
                    break;
                }
                case 'E': {
                    astroframe = Ecliptic.scan(d, d2);
                    if (astroframe != null || !bl) break;
                    astroframe = new Ecliptic(d, d2);
                }
            }
        }
        if (astroframe != null && (astroframe.fixed & 0x80) != 0) {
            astroframe.fixFrame(parsing.toString(n4 + (bl5 ? 1 : 0), n3));
        }
        return astroframe;
    }

    public static Astroframe create(String string) {
        Astroframe astroframe = Astroframe.getFrame(string);
        if (astroframe != null) {
            return astroframe;
        }
        Parsing parsing = new Parsing(string);
        astroframe = Astroframe.parse2(parsing, true);
        parsing.gobbleSpaces();
        if (astroframe == null || parsing.pos < parsing.length) {
            System.err.println("#+++Astroframe.create(" + string + "): stopped with <" + parsing + ">");
            return null;
        }
        astroframe.fixFrame(string);
        return astroframe;
    }

    public static Astroframe create(Astroframe astroframe, double d) {
        Astroframe astroframe2;
        if (astroframe == null) {
            return null;
        }
        if (Double.isNaN(d)) {
            d = astroframe.epoch;
        }
        int n = astroframe.fixed & 0xF;
        if (astroframe instanceof ICRS) {
            astroframe2 = new ICRS(d);
        } else if (astroframe instanceof Galactic) {
            astroframe2 = new Galactic(d);
        } else if (astroframe instanceof Supergal) {
            astroframe2 = new Supergal(d);
        } else if (astroframe instanceof FK5) {
            FK5 fK5 = (FK5)astroframe;
            astroframe2 = new FK5(fK5.equinox, d);
        } else if (astroframe instanceof FK4) {
            FK4 fK4 = (FK4)astroframe;
            astroframe2 = new FK4(fK4.equinox, Astrotime.J2B(d));
        } else if (astroframe instanceof Ecliptic) {
            Ecliptic ecliptic = (Ecliptic)astroframe;
            astroframe2 = new Ecliptic(ecliptic.equinox, d);
        } else {
            return null;
        }
        if (n != 0) {
            astroframe2.fixed = (byte)(astroframe2.fixed | n);
            if (astroframe2.epoch != astroframe.epoch) {
                astroframe2.name = Astroframe.updateEpoch(astroframe2.name, astroframe2.epoch, false);
                astroframe2.full_name = Astroframe.updateEpoch(astroframe2.full_name, astroframe2.epoch, true);
            }
        }
        return astroframe2;
    }

    public boolean equals(char c) {
        switch (Character.toUpperCase(c)) {
            case 'J': {
                if (this.toICRSmatrix == FK5.toICRSbase) {
                    return true;
                }
            }
            case 'I': {
                return this instanceof ICRS;
            }
            case 'G': {
                return this instanceof Galactic;
            }
            case 'B': {
                return this.toICRSmatrix == FK4.toICRSbase;
            }
        }
        return false;
    }

    public String toString() {
        return (this.fixed & 0x80) == 0 ? this.full_name : '\"' + this.name + '\"';
    }

    public final synchronized boolean fixFrame(String string) {
        Integer n;
        if (DEBUG) {
            System.out.print("#...Astroframe.fixFrame(" + string + ") for: " + this + "; fixedFrames=");
            if (fixedFrames == null) {
                System.out.println("0");
            } else {
                System.out.println(fixedFrames.size());
            }
        }
        boolean bl = false;
        if (string.length() < 1) {
            return bl;
        }
        if (fixedFrames == null) {
            if (DEBUG) {
                System.out.println("#...installing basic frames...");
            }
            fixedFrames = new ArrayList(15);
            if (fixedNames == null) {
                fixedNames = new HashMap(20);
            }
            fixedFrames.add(new ICRS(2015.5));
            fixedFrames.add(new ICRS(2000.0));
            fixedFrames.add(new Galactic(2000.0));
            fixedFrames.add(new Supergal(2000.0));
            fixedFrames.add(new FK4(1950.0, 1950.0));
            fixedFrames.add(new FK5(2000.0, 2000.0));
            fixedFrames.add(new Ecliptic(2000.0, 2000.0));
            if (DEBUG) {
                System.out.println("#...installed " + fixedFrames.size() + " basic frames...");
            }
            for (int i = 0; i < fixedFrames.size(); ++i) {
                Astroframe astroframe = (Astroframe)fixedFrames.get(i);
                n = new Integer(i);
                if (this.equals(astroframe)) {
                    if (DEBUG) {
                        System.out.println("#...replace basic frame <" + this.full_name + "> by <" + astroframe.full_name + ">");
                    }
                    fixedFrames.set(i, astroframe);
                    astroframe.name = string;
                    fixedNames.put(string, n);
                    bl = true;
                } else {
                    astroframe.name = astroframe.full_name;
                }
                astroframe.fixed = (byte)(astroframe.fixed | 0x80);
                if (fixedNames.containsKey(astroframe.full_name)) continue;
                fixedNames.put(astroframe.full_name, n);
            }
        } else if (fixedNames.containsKey(string)) {
            Integer n2 = (Integer)fixedNames.get(string);
            if (DEBUG) {
                System.out.println("#+++Astroframe.fixFrame: " + string + " already assigned to frame#" + n2);
            }
            return fixedFrames.get(n2) == this;
        }
        if ((this.fixed & 0x80) != 0) {
            Integer n3 = (Integer)fixedNames.get(this.full_name);
            if (DEBUG) {
                System.out.println("#...Astroframe.fixFrame: adding name <" + string + "> to frame#" + (n3 == null ? this.full_name : n3.toString()));
            }
            return fixedNames.put(string, n3) == null;
        }
        if (bl) {
            return bl;
        }
        n = new Integer(fixedFrames.size());
        if (fixedFrames.add(this)) {
            this.name = string;
            fixedNames.put(string, n);
            this.fixed = (byte)(this.fixed | 0x80);
            if (!fixedNames.containsKey(this.full_name)) {
                fixedNames.put(this.full_name, n);
            }
        }
        return true;
    }

    public final boolean fixFrame() {
        return this.fixFrame(this.full_name);
    }

    public boolean setFrameEpoch(double d) {
        if (this.epoch == d) {
            return true;
        }
        if ((this.fixed & 0x80) != 0) {
            return false;
        }
        this.epoch = d;
        this.name = Astroframe.updateEpoch(this.name, this.epoch, false);
        this.full_name = Astroframe.updateEpoch(this.full_name, this.epoch, true);
        return true;
    }

    public double getEpoch() {
        return this.epoch;
    }

    public final boolean isFixed() {
        return (this.fixed & 0x80) != 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Astroframe) {
            Astroframe astroframe = (Astroframe)object;
            bl = this.toICRSmatrix == astroframe.toICRSmatrix && Math.abs(this.epoch - astroframe.epoch) <= 3.168808781402895E-8;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        long l = Double.doubleToLongBits(this.epoch);
        n = n * 123 + (int)(l ^ l >>> 32);
        return n;
    }

    private final void notPossible() {
        System.out.println("#***Astroframe(" + this + ", " + this.getClass() + "): linkage to ICRS is not possible!");
    }

    public void toICRS(Coo coo) {
        coo.rotate(this.toICRSmatrix);
    }

    public void fromICRS(Coo coo) {
        coo.rotate(this.fromICRSmatrix);
    }

    public final synchronized boolean saveConversion(Astroframe astroframe, double[] dArray) {
        if (DEBUG) {
            System.out.println("#...Astroframe.saveConversion(" + astroframe + "): associate with " + dArray.length + "-double matrix");
        }
        if ((this.fixed & 0x80) == 0) {
            this.fixFrame();
        }
        if ((astroframe.fixed & 0x80) == 0) {
            astroframe.fixFrame();
        }
        if (this.savedConversions == null) {
            this.savedConversions = new HashMap(7);
        }
        if (this.savedConversions.containsKey(astroframe)) {
            return false;
        }
        this.savedConversions.put(astroframe, dArray);
        return true;
    }

    public static final double[] convertMatrix(Astroframe astroframe, Astroframe astroframe2) {
        if (astroframe.equals(astroframe2)) {
            return AstroMath.U3matrix;
        }
        boolean bl = (astroframe.fixed & astroframe2.fixed & 0x80) != 0;
        double[] dArray = null;
        if (bl && astroframe.savedConversions != null && (dArray = (double[])astroframe.savedConversions.get(astroframe2)) != null) {
            if (DEBUG) {
                System.out.println("#...Astroframe.convertMatrix(<" + astroframe + ">, <" + astroframe2 + ">) retrieved in savedConversions.");
            }
            ++astroframe.usage;
            ++astroframe2.usage;
            return dArray;
        }
        dArray = AstroMath.motionMatrix(astroframe2.fromICRSmatrix, astroframe2.epoch - astroframe.epoch, astroframe.toICRSmatrix);
        if (DEBUG) {
            System.out.println("#...Astroframe.convertMatrix(<" + astroframe + ">, <" + astroframe2 + ">) computed, size=" + dArray.length);
        }
        if (dArray.length == 18) {
            dArray = AstroMath.m6(dArray);
        }
        if (bl) {
            astroframe.saveConversion(astroframe2, dArray);
        }
        return dArray;
    }

    public static final void compute_dotMatrix(Astroframe astroframe) {
        int n;
        astroframe.max_spin = 0.0;
        astroframe.dotMatrix = null;
        double[] dArray = astroframe.toICRSmatrix;
        if (dArray.length == 9) {
            return;
        }
        double[] dArray2 = new double[36];
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            n = 0;
            while (n < 3) {
                dArray2[n2] = dArray[0 + n3] * dArray[9 + n] + dArray[3 + n3] * dArray[12 + n] + dArray[6 + n3] * dArray[15 + n];
                if (dArray2[n2] > d) {
                    d = dArray2[n2];
                }
                dArray2[3 + n2] = 0.0;
                dArray2[21 + n2] = -dArray2[n2];
                if (dArray2[21 + n2] > d) {
                    d = dArray2[21 + n2];
                }
                ++n;
                ++n2;
            }
            ++n3;
            n2 += 3;
        }
        n2 = 0;
        for (n3 = 0; n3 < 18; n3 += 6) {
            for (n = 0; n < 3; ++n) {
                dArray2[18 + n3 + n] = dArray2[n3 + 0] * dArray2[21 + n] + dArray2[n3 + 1] * dArray2[27 + n] + dArray2[n3 + 2] * dArray2[33 + n];
            }
        }
        dArray2[17] = 1.0;
        dArray2[10] = 1.0;
        dArray2[3] = 1.0;
        astroframe.max_spin = d;
        astroframe.dotMatrix = dArray2;
    }

    public static boolean test(int n, int n2) {
        double[] dArray;
        double[] dArray2;
        int n3;
        Object object;
        Object object2;
        System.out.println("#===Astroframe.test: verbosity=" + n + ", level=" + n2 + "; \u03b5=" + eps);
        if (n > 1) {
            DEBUG = true;
        }
        boolean bl = true;
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = 3.14 * Math.random();
        }
        double[] dArray4 = new double[]{dArray3[0], dArray3[1], dArray3[2]};
        int n4 = n2 * 1000;
        double d = Math.rint(1855.0 + 200.0 * Math.random());
        FK4 fK4 = new FK4(d, d);
        if (n > 0) {
            System.out.print("\n#...Testing Eterm for " + fK4 + " (random epoch)");
        }
        for (int i = 0; i < n4; ++i) {
            if (i < 5 && n > 1) {
                System.out.println(AstroMath.toString("#...before addEterm", dArray3));
            }
            fK4.addEterm(dArray3);
            if (i < 5 && n > 1) {
                System.out.println(AstroMath.toString("#....after addEterm", dArray3));
            }
            fK4.subEterm(dArray3);
            if (i >= 5 || n <= 1) continue;
            System.out.println(AstroMath.toString("#....after subEterm", dArray3));
        }
        bl &= AstroMath.checkArray("#...#...Eterm change with " + n4 + " trials:", dArray3, dArray4);
        double[] dArray5 = AstroMath.m36p(FK5.toICRSbase, FK4.X0);
        if (n > 0) {
            System.out.print("\n#---Recompute FK4 to ICRS rotation+spin:\n");
            AstroMath.printMatrix("#...FK4.toICRSmatrix ........\n", FK4.toICRSbase);
            AstroMath.printMatrix("#...FK5.toICRSmatrix * FK4.X0\n", dArray5);
            AstroMath.checkArray("#--Differences:", dArray5, FK4.toICRSbase);
        } else {
            bl &= AstroMath.diffArray(dArray5, FK4.toICRSbase) > 8.0 * eps;
        }
        if (n > 0) {
            object2 = AstroMath.motionMatrix(50.0002095577002, FK4.toICRSbase);
            AstroMath.printMatrix("#...6x6 matrix which gives coordinates in ICRS from FK4, recomputed:\n", (double[])object2);
            object2 = AstroMath.motionMatrix(FK4.fromICRSbase, -50.0002095577002, AstroMath.U3matrix);
            AstroMath.printMatrix("#---6x6 matrix which gives coordinates in FK4 from ICRS, recomputed:\n", (double[])object2);
            object2 = AstroMath.m3p(FK4.toICRSbase, AstroMath.rotation("zyz", 192.25, 62.6, 57.0));
            bl &= AstroMath.checkArray("#...GalToICRS:", (double[])object2, Galactic.toICRSbase);
            bl &= AstroMath.checkArray("#...ICRStoGal:", (double[])object2, Galactic.fromICRSbase);
            object2 = AstroMath.rotation("zx", 137.37, 83.68);
            bl &= AstroMath.checkArray("#...toGalMatrix:", Supergal.toGalMatrix, (double[])object2);
            object2 = AstroMath.m3p(Supergal.fromGalMatrix, Galactic.fromICRSbase);
            bl &= AstroMath.checkArray("#...ICRStoSGal:", (double[])object2, Supergal.fromICRSbase);
            object2 = AstroMath.m3p(Galactic.toICRSbase, Supergal.toGalMatrix);
            bl &= AstroMath.checkArray("#...SGalToICRS:", (double[])object2, Supergal.toICRSbase);
            System.out.println("#---Trying to get Frames: Galactic.FK4(), then Galactic.Gaia2()");
            object = Galactic.Gaia2();
            ((Astroframe)object).dump("#...Galactic.Gaia (R)");
            AstroMath.checkArray("--Diff. with toICRSbase:", ((Astroframe)object).toICRSmatrix, Galactic.toICRSbase);
        }
        object2 = Galactic.Gaia2();
        object = new Astroframe[]{Astroframe.create("ICRS(2000)"), Astroframe.create("ICRS(2015.5)"), Astroframe.create("J2000"), Astroframe.create("FK5(B1950)"), Astroframe.create("B1950"), Astroframe.create("B1875"), Astroframe.create("Gal(B1950)"), Astroframe.create("SGal(B1950)"), Astroframe.create("Ecl(2015.5"), Astroframe.Hipparcos(), object2, Astroframe.create("Bad.12")};
        int n5 = ((Astroframe[])object).length;
        for (int i = 0; i < n5; ++i) {
            System.out.println("#...Frame#" + i + ":\t" + (object[i] == null ? "null" : object[i].toString()));
        }
        if (object[--n5] != null) {
            bl = false;
            object[n5].dump("#***should be null??");
        }
        Astroframe astroframe = Astroframe.create((Astroframe)object2, 2000.0);
        if (n > 0) {
            ((Astroframe)object2).dump("#...gaga (GalacticGaia):");
            astroframe.dump("#...gaga2 (cloned):");
            bl &= astroframe.fixFrame("gaga2k");
            astroframe.dump("#...gaga2 (fixed):");
        }
        if (n > 0) {
            for (n3 = 0; n3 < n5; ++n3) {
                System.out.println("\n#...Frame#" + n3 + ": " + object[n3]);
                AstroMath.printMatrix("#.....toICRSmatrix:\n", ((Astroframe)object[n3]).toICRSmatrix);
                AstroMath.printMatrix("#...fromICRSmatrix:\n", ((Astroframe)object[n3]).fromICRSmatrix);
                double[] dArray6 = AstroMath.m36p(((Astroframe)object[n3]).fromICRSmatrix, ((Astroframe)object[n3]).toICRSmatrix);
                AstroMath.checkUnity("#.....Product=.....", dArray6);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (int i = n3; i < n5; ++i) {
                System.out.println("#...fixedFrames[1]=" + fixedFrames.get(1));
                if (n > 0) {
                    System.out.println("\n#---Conversion " + object[n3] + " <=> " + object[i]);
                }
                dArray2 = Astroframe.convertMatrix((Astroframe)object[n3], (Astroframe)object[i]);
                dArray = Astroframe.convertMatrix((Astroframe)object[i], (Astroframe)object[n3]);
                if (n > 0) {
                    AstroMath.printMatrix("#=>", dArray2);
                    AstroMath.printMatrix("#<=", dArray);
                    AstroMath.printMatrix("#==", AstroMath.m36p(dArray2, dArray));
                }
                bl &= AstroMath.checkUnity("#...Diff [1]:", AstroMath.m36p(dArray2, dArray));
                if (n <= 0) continue;
                System.out.println("#===for " + object[n3] + " <=> " + object[i] + ", \u0394t=" + (((Astroframe)object[i]).epoch - ((Astroframe)object[n3]).epoch) + "Jyr.");
            }
        }
        System.out.println("#...fixedFrames[1]=" + fixedFrames.get(1));
        System.out.println("\n\n#===Tour between all " + n5 + " frames===");
        dArray2 = Astroframe.convertMatrix((Astroframe)object[1], (Astroframe)object[0]);
        dArray = Astroframe.convertMatrix((Astroframe)object[n5 - 1], (Astroframe)object[0]);
        for (n3 = 2; n3 < n5; ++n3) {
            dArray2 = AstroMath.m36p(dArray2, Astroframe.convertMatrix((Astroframe)object[n3], (Astroframe)object[n3 - 1]));
            if (n <= 0) continue;
            AstroMath.printMatrix("#...Conversion " + object[n3] + " => " + object[0] + "\n", dArray2);
            AstroMath.checkArray("#...compare with direct conversion:", dArray2, Astroframe.convertMatrix((Astroframe)object[n3], (Astroframe)object[0]));
        }
        Astroframe.dumpAll("\n#===List of All Saved Frames (R):");
        if (n == 0) {
            System.out.println(bl ? " (ok)" : " **problem(s)**");
        } else if (bl) {
            System.out.println("#---End of tests: ok");
        } else {
            System.out.println("#***Bad ** tests?");
        }
        return bl;
    }
}

